# Public Available Data Sets

The data sets presented in the following table are publicly available in several online repositories, and have been used in several published works related to causal discovery.
| Paper | Data sets |Type|
|---|---|---|
| [K. Yu, L. Liu, and J. Li, &quot;A unified view of causal and non-causal feature selection,&quot; _arXiv_, 2018.](https://arxiv.org/abs/1802.05844) | [Mushroom](https://archive.ics.uci.edu/ml/datasets/mushroom), [Kr-vs-kp](https://archive.ics.uci.edu/ml/datasets/Chess+(King-Rook+vs.+King-Pawn)), [Madelon](https://jundongl.github.io/scikit-feature/datasets.html), [Gisette](https://jundongl.github.io/scikit-feature/datasets.html.),[Spambase](https://archive.ics.uci.edu/ml/datasets/spambase), [Bankruptcy](https://archive.ics.uci.edu/ml/datasets/qualitative_bankruptcy), [Prostate](https://jundongl.github.io/scikit-feature/datasets.html), [Dexter](https://archive.ics.uci.edu/ml/datasets/Dexter), [Arcene](https://jundongl.github.io/scikit-feature/datasets.html), [Dorothea](https://archive.ics.uci.edu/ml/datasets/Dorothea), [Leukemia](https://jundongl.github.io/scikit-feature/datasets.html), [Breast cancer](https://archive.ics.uci.edu/ml/datasets/breast+cancer), [Connect-4](http://archive.ics.uci.edu/ml/datasets/connect-4), [Splice](https://archive.ics.uci.edu/ml/datasets/Molecular+Biology+(Splice-junction+Gene+Sequences)), [Waveform](https://archive.ics.uci.edu/ml/datasets/Waveform+Database+Generator+%28Version+1%29), [Lung](https://jundongl.github.io/scikit-feature/datasets.htmlg), [Lymph](https://jundongl.github.io/scikit-feature/datasets.html), [nci9](https://jundongl.github.io/scikit-feature/datasets.html), [Sido](http://www.causality.inf.ethz.ch/data/SIDO.html), [Thrombin](http://pages.cs.wisc.edu/~dpage/kddcup2001/) | Discrete data|
| [Nogueira A.R., Gama J., Ferreira C.A. (2020) Improving Prediction with Causal Probabilistic Variables. In: Berthold M., Feelders A., Krempl G. (eds) Advances in Intelligent Data Analysis XVIII. IDA 2020. Lecture Notes in Computer Science, vol 12080. Springer, Cham. https://doi.org/10.1007/978-3-030-44584-3\_30](https://link.springer.com/chapter/10.1007/978-3-030-44584-3_30#citeas) | [Breast cancer](https://archive.ics.uci.edu/ml/datasets/breast+cancer), [cervical](https://github.com/AnaRitaNogueira/Causality-Repository/tree/master/cervical), [corral](https://www.openml.org/d/40669), [earthquake](https://github.com/AnaRitaNogueira/Causality-Repository/tree/master/earthquake), [head injury](https://vincentarelbundock.github.io/Rdatasets/datasets.html), [lucas](http://www.causality.inf.ethz.ch/data/LUCAS.html), [medpar](https://vincentarelbundock.github.io/Rdatasets/articles/data.html), [mifem](https://vincentarelbundock.github.io/Rdatasets/articles/data.html), [qualitative bankruptcy](https://archive.ics.uci.edu/ml/datasets/Qualitative_Bankruptcy), [respiratory](http://vincentarelbundock.github.io/Rdatasets/articles/datcentre%20the%20study%20center,%20a%20factor%20with%20levels%201%20and%202.a.html), [survey](https://github.com/AnaRitaNogueira/Causality-Repository/tree/master/survey), [titanic](https://vincentarelbundock.github.io/Rdatasets/datasets.html), [xd6](https://vincentarelbundock.github.io/Rdatasets/datasets.html) | Discrete data|
| [Ruocheng Guo, Lu Cheng, Jundong Li, P. Richard Hahn, and Huan Liu. 2020. A Survey of Learning Causality with Data: Problems and Methods. ACM Comput. Surv. 53, 4, Article 75 (September 2020), 37 pages. DOI:https://doi.org/10.1145/3397269](https://dl.acm.org/doi/10.1145/3397269) | [Abalone](http://archive.ics.uci.edu/ml/datasets/Abalone), [IHDP](hhttps://github.com/AMLab-Amsterdam/CEVAE/tree/master/datasets/IHDP), [TWINS](https://github.com/AMLab-Amsterdam/CEVAE/tree/master/datasets/TWINS), [causal pairs](https://webdav.tuebingen.mpg.de/cause-effect/) |----------------------|
| [Huang, Yuxiao, and Samantha Kleinberg. &quot;Fast and accurate causal inference from time series data.&quot; The Twenty-Eighth International Flairs Conference. 2015.](https://d1wqtxts1xzle7.cloudfront.net/37392191/huang_flairs15.pdf?1429716585=&amp;response-content-disposition=inline%3B+filename%3DFast_and_Accurate_Causal_Inference_from.pdf&amp;Expires=1611255529&amp;Signature=TOeW7o3RDjwLy6qwurN~LLNYD31A-VhPVosR8yIgo90EwU6oO~VeUbLqEtdZP3xvkuLkHiDx5s87Lj3-fat1~NRwr7VM2NjHEo4l8P2mi9kQ62uVw79h3bvLZhpcYAI3ynMNe6f9zkpHFjvg7DDgz0ofxBao8MNz0arjuwz9Ud~gNQjGb3z3lznuuyr96VDyMyBQIBDUtC82aFGWgG-hzFk1yF~c8v50MjjeMFgns-a6Q7d9U6pd0Xyzio~2HJmpFoTIVfaT3Kk4Nd59b0Zm5~Y4H4Vsmvm0b40-HUWzKKZZ~9HbJy~wMKxyX3pO5zWh0zv1kyc29ticRWKZkG--8Q__&amp;Key-Pair-Id=APKAJLOHF5GGSLRBV4ZA) | [FLAIRS](http://www.skleinberg.org/data.html) |Time-series data, continuous data|
| [Kleinberg, Samantha. Causality, probability, and time. Cambridge University Press, 2013.](https://books.google.pt/books?hl=pt-PT&amp;lr=&amp;id=KHwqL43SaZQC&amp;oi=fnd&amp;pg=PR7&amp;dq=Causality,+Probability,+and+Time&amp;ots=Lff-d7vZz9&amp;sig=6_C-PCQqpVGaOP0nJALQhTyUEWg&amp;redir_esc=y#v=onepage&amp;q=Causality%2C%20Probability%2C%20and%20Time&amp;f=false) | [FinanceCPT](http://www.skleinberg.org/data.html) |Tme-series data|
|[S. A. Rahman, C. Merck, Yuxiao Huang and S. Kleinberg, "Unintrusive eating recognition using Google Glass," 2015 9th International Conference on Pervasive Computing Technologies for Healthcare (PervasiveHealth), Istanbul, 2015, pp. 108-111, doi: 10.4108/icst.pervasivehealth.2015.259044.](https://ieeexplore.ieee.org/document/7349385)|[GLEAM dataset](http://www.skleinberg.org/data/GLEAM.tar.gz)<sup>[1](#myfootnote1.1)</sup><sup>[2](#myfootnote1.2)</sup>| Time-series data|
[J. Li, S. Ma, T. Le, L. Liu and J. Liu, "Causal Decision Trees," in IEEE Transactions on Knowledge and Data Engineering, vol. 29, no. 2, pp. 257-271, 1 Feb. 2017, doi: 10.1109/TKDE.2016.2619350.](https://ieeexplore.ieee.org/document/7600471)|[CINA](http://www.causality.inf.ethz.ch/data/CINA.html) (also called Adult data set)|Mixed data|

*<sub>
<a name="myfootnote1.1">1</a>: "Use of the data is permitted for non-commercial research and education purposes provided you properly credit the data source"<br>
 <a name="myfootnote1.2">3</a>: "Use of the data is permitted for non-commercial research and education purposes provided do not redistribute the data (with or without modification)"
  <suv/>*

# Data sets Available Throught Request

In this section, we present several data sets that are available through resquest (for example, filling a form).
| Paper | Data sets |Type|
|---|---|---|
|[Mark Mirtchouk, Drew Lustig, Alexandra Smith, Ivan Ching, Min Zheng, and Samantha Kleinberg. 2017. Recognizing Eating from Body-Worn Sensors: Combining Free-living and Laboratory Data. Proc. ACM Interact. Mob. Wearable Ubiquitous Technol. 1, 3, Article 85 (September 2017), 20 pages. DOI:https://doi.org/10.1145/3131894](https://dl.acm.org/doi/10.1145/3131894)|[ACE Free-living dataset](http://skleinberg.org/data/ACE-FL.html)<sup>[1](#myfootnot1)</sup><sup>[2](#myfootnote2)</sup><sup>[3](#myfootnote3)</sup>|Time-series data|
|[Christopher Merck, Christina Maher, Mark Mirtchouk, Min Zheng, Yuxiao Huang, and Samantha Kleinberg. 2016. Multimodality sensing for eating recognition. In Proceedings of the 10th EAI International Conference on Pervasive Computing Technologies for Healthcare (PervasiveHealth '16). ICST (Institute for Computer Sciences, Social-Informatics and Telecommunications Engineering), Brussels, BEL, 130–137.](https://dl.acm.org/doi/10.5555/3021319.3021339)<br>[Mark Mirtchouk, Christopher Merck, and Samantha Kleinberg. 2016. Automated estimation of food type and amount consumed from body-worn audio and motion sensors. In Proceedings of the 2016 ACM International Joint Conference on Pervasive and Ubiquitous Computing (UbiComp '16). Association for Computing Machinery, New York, NY, USA, 451–462. DOI:https://doi.org/10.1145/2971648.2971677](https://dl.acm.org/doi/10.1145/2971648.2971677)|[ACE dataset (lab)](http://skleinberg.org/data/ACE.html)<sup>[1](#myfootnote2.1)</sup><sup>[2](#myfootnote2.2)</sup><sup>[3](#myfootnote2.3)</sup>|Time-series data|

*<sub>
<a name="myfootnote2.1">1</a>: "Use of the data is permitted for non-commercial research and education purposes provided you properly credit the data source"<br>
<a name="myfootnote2.2">2</a>: "Use of the data is permitted for non-commercial research and education purposes provided you do not attempt to identify participants in the study"<br>
<a name="myfootnote2.3">3</a>: "Use of the data is permitted for non-commercial research and education purposes provided do not redistribute the data (with or without modification)"
<sub/>*
  
  
  # Other causal discovery data sets
  These data sets are identified in the various sources as causal discovery data sets. However, they are classified as causal discovery data sets in various sources.

 Data set |Type|Source Location|
|---|---|---|
|Abscisic Acid Signaling Network Data Set|Discrete data|[UCI Repository](https://archive.ics.uci.edu/ml/datasets/Abscisic+Acid+Signaling+Network)|
|Gas Sensor Array Drift Dataset at Different Concentrations Data Set)<sup>[1](#myfootnote3.1)</sup>|Mixed data|[UCI Repository](https://archive.ics.uci.edu/ml/datasets/Gas+Sensor+Array+Drift+Dataset+at+Different+Concentrations)|
[Horton General Hospital Data Set|Time-series data|[UCI Repository](https://archive.ics.uci.edu/ml/datasets/Gas+Sensor+Array+Drift+Dataset+at+Different+Concentrations)|
|REGED|Discrete data|[Causality Workbench](http://www.causality.inf.ethz.ch/data/REGED.html)|
|SECOM Data Set|Continuous data|[UCI Repository](https://archive.ics.uci.edu/ml/datasets/SECOM)|
|StoneFlakes Data Set|Mixed data|[UCI Repository](https://archive.ics.uci.edu/ml/datasets/StoneFlakes)|
|SIGNET|Binary data| [Causality Workbench](www.causality.inf.ethz.ch/)|
|STEFI|Mixed data| [Causality Workbench](www.causality.inf.ethz.ch/)|
UbiqLog|Time-series data|[UCI Repository](https://archive.ics.uci.edu/ml/datasets/UbiqLog+(smartphone+lifelogging))|
|MARTI|Countinuous data|[Causality Workbanch](http://www.causality.inf.ethz.ch/data/MARTI.html)|
|PROMO|Time-series data|[Causality Workbench](http://clopinet.com/causality/data/promo/)
[Pedestrian in Traffic Dataset Data Set<sup>[2](#myfootnote3.2)</sup>|Time-series data|[UCI Repository](https://archive.ics.uci.edu/ml/datasets/Pedestrian+in+Traffic+Dataset)|
|Dunnhumby - The Complete Journey | Time-series data | [Kaggle](https://www.kaggle.com/frtgnn/dunnhumby-the-complete-journey?select=causal_data.csv) | 
| Figure Eight: Medical Sentence Summary | Time-series data | [Kaggle](https://www.kaggle.com/kmader/figure-eight-medical-sentence-summary?select=validation.csv) |Confused student EEG brainwave data | Continuous data | [Kaggle](https://www.kaggle.com/wanghaohan/confused-eeg?select=demographic_info.csv) |
|CausalML Package Example Dataset | Mixed data | [Kaggle](https://www.kaggle.com/vikasmalhotra08/causalml-package-example-dataset?select=ihdp_npci_4.csv) |
|Temperature and cherry blossom status | Time-series data | [Kaggle](https://www.kaggle.com/akioonodera/temperature-and-flower-status)|
|Uplift Modeling , Marketing Campaign Data | Continuous data | [Kaggle](https://www.kaggle.com/arashnic/uplift-modeling)|
|Loneliness and Social Connections | Mixed data | [Kaggle](https://www.kaggle.com/arashnic/loneliness-and-social-connections?select=percent-of-men-and-women-using-social-media-platforms-in-the-us.csv) |
| CausaLM Datasets | Mixed data | [Kaggle](https://www.kaggle.com/amirfeder/causalm?select=topics_dev.csv) |
|Historical Gold Stock-GLD (EFT) | Time-series data | [Kaggle](https://www.kaggle.com/kalpanadontha/historicalgoldstockrandgoldresources) |
|Medical Information Extraction |  Time-series data | [Kaggle](https://www.kaggle.com/mathurinache/medical-information-extraction)|
|Influenza and Env Factors | Time-series data | [Kaggle](https://www.kaggle.com/ffejgnaw/weekly-influenza-and-env-factors-2016-2018)|
|National Footprint Accounts 2018 | Longitudinal data | [Kaggle](https://www.kaggle.com/footprintnetwork/national-footprint-accounts-2018)|
|School Shootings US 1990-present | Time-series data | [Kaggle](https://www.kaggle.com/ecodan/school-shootings-us-1990present?select=cps_01_formatted.csv)|
|Deaths related to the Northern Ireland conflict | Mixed data | [Kaggle](https://www.kaggle.com/cclayford/deaths-related-to-the-northern-ireland-conflict) |
|Proper-names Categories | Discrete data | [Kaggle](https://www.kaggle.com/vered1986/propernames-categories?select=dataset_full.csv)|


*<sub>
<a name="myfootnote3.1">1</a>: "Citation of both papers is required:<br>
A Vergara, S Vembu, T Ayhan, M Ryan, M Homer, R Huerta. "Chemical gas sensor drift compensation using classifier ensembles." Sensors and Actuators B: Chemical 166 (2012): 320-329.;
I Rodriguez-Lujan, J Fonollosa, A Vergara, M Homer, R Huerta. "On the calibration of sensor arrays for pattern recognition using the minimal number of experiments." Chemometrics and Intelligent Laboratory Systems 130 (2014): 123-134."<br>
<a name="myfootnote3.2">2</a>: "You may use this data for scientific, non-commercial purposes, as long as you give credit to the owners when publishing any work based on this data. Please cite Blaiotta, Claudia. 'Learning generative socially-aware models of pedestrian motion.' IEEE Robotics and Automation Letters, 2019."
<sub/>*
